﻿using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;
using Mdws2ORM.QuerySvcService;
using BMS.VistaIntegration.Mdws.Commands.EntityCommands;
using BMS.VistaIntegration.Mdws.Commands.SubEntityCommands;
using System;
using Mdws2ORM.Maps.SingleMaps;
using Mdws2ORM;
using BMS.VistaIntegration.Mdws.Commands.Concrete.WF;
using BMS.Utils;
using BMS.VistaIntegration.Mdws.Commands.Concrete;

namespace BMS.VistaIntegration.Mdws.Commands.Concrete.WF
{
    public class ListPatientAppointmentFromClinicsAndPatientCommand
    {
        public string PatientIen { get; set; }
        public IEnumerable<string> ClinicIens { get; set; }
        public DateTime? StartTime { get; set; }
        public DateTime? EndTime { get; set; }
        public int? MaxCount { get; set; }

        public IList<PatientAppointment> Execute(ISession session)
        {
            ListPatientAppointmentFromPatientCommand command = new ListPatientAppointmentFromPatientCommand();
            command.PatientIen = PatientIen;
            command.MaxCount = MaxCount;
            command.StartTime = StartTime;
            command.EndTime = EndTime;
            HashSet<string> clinics = new HashSet<string>(ClinicIens);
            IList<PatientAppointment> patientAppointments = command.Execute(session);
            IList<PatientAppointment> result = patientAppointments.Where((pat) => clinics.Contains(pat.HospitalLocationId)).ToList();
            return result;
        }
    }
}
